package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Reporte;

import java.util.ArrayList;

public class ReporteAdapter extends RecyclerView.Adapter<ReporteAdapter.ReportesViewHolder>{

    Context context;
    ArrayList<Reporte> reportes;

    public ReporteAdapter(Context context, ArrayList<Reporte> reportes) {
        this.context = context;
        this.reportes = reportes;
    }

    @NonNull
    @Override
    public ReporteAdapter.ReportesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(context).inflate(R.layout.reporte_item, parent, false);
        return new ReporteAdapter.ReportesViewHolder(v);
    }

    public void setListaFiltrada(ArrayList<Reporte> filteredList){
        this.reportes= filteredList;
        notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(@NonNull ReporteAdapter.ReportesViewHolder holder, int position) {
        holder.imprimir(position);
    }

    @Override
    public int getItemCount() {
        return reportes.size();
    }

    public void clear() {
        reportes.clear();
        notifyDataSetChanged();
    }

    public void addAll(ArrayList<Reporte> list) {
        reportes = list;
        notifyDataSetChanged();
    }

    public class ReportesViewHolder extends RecyclerView.ViewHolder {

        TextView tvPoblacion, tvEstimado, tvPagado, tvFaltante, tvCantidadPrestamos;

        public ReportesViewHolder(@NonNull View itemView) {
            super(itemView);

            tvPoblacion = itemView.findViewById(R.id.tvPoblacion);
            tvEstimado = itemView.findViewById(R.id.tvEstimado);
            tvPagado = itemView.findViewById(R.id.tvPagado);
            tvFaltante = itemView.findViewById(R.id.tvFaltante);
            tvCantidadPrestamos = itemView.findViewById(R.id.tvCantidad);

        }

        public void imprimir(int position) {

            tvPoblacion.setText(reportes.get(position).getNombre_poblacion() + " " + reportes.get(position).getFecha_pago() );
            tvEstimado.setText("$" + (reportes.get(position).getEstimado() == null ? "0.0" : reportes.get(position).getEstimado()));
            tvPagado.setText("$" + (reportes.get(position).getPagado() == null ? "0.0" : reportes.get(position).getPagado()));
            tvFaltante.setText("$" + (reportes.get(position).getFaltante() == null ? "0.0" : reportes.get(position).getFaltante()));
            tvCantidadPrestamos.setText((reportes.get(position).getCantidad_prestamos() == null ? "0" : reportes.get(position).getCantidad_prestamos()));

        }

    }
}
